import std.c.stdio;
import std.string;
import win32.winbase;
import win32.windows;
import getnames;


alias std.string.toStringz c_str;
alias std.string.toString   d_str;
alias char [] string;

interface Debugger
{

	bit load(string path );
	bit run();

}

class Win32Debugger : Debugger
{
protected:
	string path;

public:

	bit load(string _path )
	{
		/* might do other stuff here, not sure yet */

		path = _path;
		return true;
	}

	bit run ()
	{
		DEBUG_EVENT dbg;
		STARTUPINFOA startup;
		startup.cb=startup.sizeof;

		PROCESS_INFORMATION output;

		int result = CreateProcessA (null, c_str(path), null, null, false,  DEBUG_PROCESS | DEBUG_ONLY_THIS_PROCESS, null, null, &startup, &output);



		while ( true )
		{
			WaitForDebugEvent(&dbg, INFINITE);

			debug {  msgBox(get_event_name(dbg.dwDebugEventCode)  ) ; }

			switch ( dbg.dwDebugEventCode )
			{
				case EXCEPTION_DEBUG_EVENT	:
				{
					
					debug {  msgBox(get_exception_name(dbg.Exception.ExceptionRecord.ExceptionCode) ) ; } 
					break;
				}

				case CREATE_THREAD_DEBUG_EVENT	:
				{
					break;
				}

				case CREATE_PROCESS_DEBUG_EVENT	:
				{
					break;
				}

				case EXIT_THREAD_DEBUG_EVENT	:
				{
					break;
				}

				case EXIT_PROCESS_DEBUG_EVENT	:
				{
					break;
				}

				case LOAD_DLL_DEBUG_EVENT	:
				{
					break;
				}

				case UNLOAD_DLL_DEBUG_EVENT	:
				{
					break;
				}

				case OUTPUT_DEBUG_STRING_EVENT	:
				{
					break;
				}


				case RIP_EVENT:
				{
					break;
				}

			}


			ContinueDebugEvent(output.dwProcessId, output.dwThreadId, DBG_CONTINUE);
		}

		return true;

	}

}


void main ()
{

	Win32Debugger d = new Win32Debugger;
	d.load("C:\\foo.exe");
	d.run();
}

void msgBox(char [] x ) {
	
	MessageBoxA(null,x  ,null,0 );
}

